/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.draft;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.lib.tile.SyncVariable;

public abstract class PlayerDataHandler<Data extends PlayerData> {
    private final String nbtRootKey;
    private final Map<Integer, Data> playerData = new HashMap<Integer, Data>();
    private Data emptyData;

    protected PlayerDataHandler(ResourceLocation nbtRootKey) {
        this.nbtRootKey = nbtRootKey.toString().replace(':', '_');
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler(this));
    }

    public abstract <T extends PlayerDataHandler> T instance();

    protected abstract Data createData(@Nullable EntityPlayer var1);

    public Data get(EntityPlayer player) {
        PlayerData data;
        if (player == null || player instanceof FakePlayer) {
            if (this.emptyData == null) {
                this.emptyData = this.createData(null);
            }
            return this.emptyData;
        }
        int key = PlayerDataHandler.getKey(player);
        if (!this.playerData.containsKey(key)) {
            this.playerData.put(key, this.createData(player));
        }
        if ((data = (PlayerData)this.playerData.get(key)) != null && data.getPlayer() != player) {
            NBTTagCompound tags = new NBTTagCompound();
            data.writeToNBT(tags);
            this.playerData.remove(key);
            data = this.get(player);
            data.readFromNBT(tags);
        }
        return (Data)data;
    }

    private void cleanup() {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int key : this.playerData.keySet()) {
            PlayerData data = (PlayerData)this.playerData.get(key);
            if (data == null || data.isValid()) continue;
            toRemove.add(key);
        }
        for (int key : toRemove) {
            this.playerData.remove(key);
        }
    }

    private static int getKey(EntityPlayer player) {
        return player.hashCode() << 1 + (player.field_70170_p.field_72995_K ? 1 : 0);
    }

    private NBTTagCompound getDataCompoundForPlayer(EntityPlayer player) {
        NBTTagCompound persistentData;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistentData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(this.nbtRootKey)) {
            persistentData.func_74782_a(this.nbtRootKey, (NBTBase)new NBTTagCompound());
        }
        return persistentData.func_74775_l(this.nbtRootKey);
    }

    public static class EventHandler {
        private final PlayerDataHandler<?> handler;

        private EventHandler(PlayerDataHandler<?> handler) {
            this.handler = handler;
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ((PlayerDataHandler)this.handler).cleanup();
            }
        }

        @SubscribeEvent
        public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                ((PlayerData)this.handler.get((EntityPlayer)event.getEntityLiving())).tick();
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.player instanceof EntityPlayerMP) {
                EntityPlayerMP entityPlayerMP = (EntityPlayerMP)event.player;
            }
        }
    }

    public abstract class PlayerData {
        private WeakReference<EntityPlayer> playerWR;
        protected final boolean client;

        protected PlayerData(EntityPlayer player) {
            this.playerWR = new WeakReference<EntityPlayer>(player);
            this.client = player.field_70170_p.field_72995_K;
            this.load();
        }

        @Nullable
        public final EntityPlayer getPlayer() {
            return (EntityPlayer)this.playerWR.get();
        }

        public boolean isValid() {
            return this.playerWR != null;
        }

        public abstract void tick();

        protected void sendUpdateMessage() {
            if (!this.client) {
                EntityPlayer entityPlayer = (EntityPlayer)this.playerWR.get();
            }
        }

        public final void save() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = PlayerDataHandler.this.getDataCompoundForPlayer(player);
                this.writeToNBT(tags);
                SyncVariable.Helper.writeSyncVars(this, tags, SyncVariable.Type.WRITE);
            }
        }

        public abstract void writeToNBT(NBTTagCompound var1);

        public final void load() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = PlayerDataHandler.this.getDataCompoundForPlayer(player);
                this.readFromNBT(tags);
                SyncVariable.Helper.readSyncVars(this, tags);
            }
        }

        public abstract void readFromNBT(NBTTagCompound var1);
    }
}

